<?php
// Include this file at the beginning of pages that require authentication

// Check if user is logged in
if (!isLoggedIn()) {
    setFlashMessage('danger', 'Please log in to access this page');
    redirect(APP_URL . '/pages/login.php');
}

// Get current user ID
$userId = $_SESSION['user_id'];

// Get user data
$currentUser = getUserById($userId);

// Check if user exists
if (!$currentUser) {
    // Destroy session if user doesn't exist
    session_destroy();
    setFlashMessage('danger', 'User account not found');
    redirect(APP_URL . '/pages/login.php');
}