<?php
require_once 'config.php';
require_once 'db.php';

// Function to check if user is logged in
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

// Function to redirect
function redirect($url) {
    header("Location: " . $url);
    exit();
}

// Function to sanitize input
function sanitize($input) {
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

// Function to generate a random string
function generateRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

// Function to upload image
function uploadImage($file, $destination) {
    // Check if file was uploaded without errors
    if ($file['error'] == 0) {
        $allowed = ['jpg', 'jpeg', 'png', 'gif'];
        $filename = $file['name'];
        $fileTmp = $file['tmp_name'];
        $fileExt = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        
        // Check if file type is allowed
        if (in_array($fileExt, $allowed)) {
            // Generate a unique filename
            $newFilename = generateRandomString() . '.' . $fileExt;
            $destination = rtrim($destination, '/') . '/' . $newFilename;
            
            // Move uploaded file to destination
            if (move_uploaded_file($fileTmp, $destination)) {
                return $newFilename;
            }
        }
    }
    return false;
}

// Flash message system
function setFlashMessage($type, $message) {
    $_SESSION['flash'] = [
        'type' => $type,
        'message' => $message
    ];
}

function getFlashMessage() {
    if (isset($_SESSION['flash'])) {
        $flash = $_SESSION['flash'];
        unset($_SESSION['flash']);
        return $flash;
    }
    return null;
}

// Function to check if permalink exists
function permalinkExists($permalink) {
    global $db;
    $result = $db->selectOne("SELECT id FROM users WHERE permalink = ?", [$permalink]);
    return $result ? true : false;
}

// Function to get user by ID
function getUserById($userId) {
    global $db;
    return $db->selectOne("SELECT * FROM users WHERE id = ?", [$userId]);
}

// Function to get book by ID
function getBookById($bookId) {
    global $db;
    return $db->selectOne("SELECT * FROM books WHERE id = ?", [$bookId]);
}

// Function to get buttons by book ID
function getButtonsByBookId($bookId) {
    global $db;
    return $db->select("SELECT * FROM buttons WHERE book_id = ? ORDER BY position", [$bookId]);
}

// Function to get social links by user ID
function getSocialLinksByUserId($userId) {
    global $db;
    return $db->select("SELECT * FROM social_links WHERE user_id = ?", [$userId]);
}
?>