<?php
// Main index file for the BookLinks application
require_once 'includes/config.php';
require_once 'includes/db.php';
require_once 'includes/functions.php';

// Track page views and link clicks
if (isset($_GET['track'])) {
    $trackData = json_decode(base64_decode($_GET['track']), true);
    
    if (isset($trackData['type']) && isset($trackData['id'])) {
        $type = sanitize($trackData['type']);
        $id = (int)$trackData['id'];
        
        if ($type === 'link' && isset($trackData['book_id']) && isset($trackData['user_id'])) {
            $bookId = (int)$trackData['book_id'];
            $userId = (int)$trackData['user_id'];
            
            // Track link click
            $clickData = [
                'button_id' => $id,
                'book_id' => $bookId,
                'user_id' => $userId,
                'visitor_ip' => $_SERVER['REMOTE_ADDR']
            ];
            
            $db->insert('link_clicks', $clickData);
        }
        
        // Redirect to the actual URL
        if (isset($trackData['url'])) {
            header('Location: ' . $trackData['url']);
            exit;
        }
    }
}

// Check if permalink is provided in the URL
if (isset($_GET['permalink'])) {
    $permalink = sanitize($_GET['permalink']);
    
    // Get user by permalink
    $user = $db->selectOne("SELECT * FROM users WHERE permalink = ?", [$permalink]);
    
    if ($user) {
        // Get the user's books
        $books = $db->select("SELECT * FROM books WHERE user_id = ? AND is_published = 1", [$user['id']]);
        
        if (count($books) > 0) {
            // Get the first book (for now we'll just show one book)
            $book = $books[0];
            
            // Get buttons for this book
            $buttons = getButtonsByBookId($book['id']);
            
            // Get social links for this user
            $socialLinks = getSocialLinksByUserId($user['id']);
            
            // Track page view
            $pageViewData = [
                'page_type' => 'book',
                'page_id' => $book['id'],
                'user_id' => $user['id'],
                'visitor_ip' => $_SERVER['REMOTE_ADDR'],
                'visitor_user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? '',
                'referrer' => $_SERVER['HTTP_REFERER'] ?? ''
            ];

            $db->insert('page_views', $pageViewData);
            
            // Include the book display template
            include 'templates/book_display.php';
            exit;
        }
    }
    
    // If no user or books found, show 404
    header("HTTP/1.0 404 Not Found");
    include 'templates/404.php';
    exit;
}

// If no permalink provided, show the main landing page
include 'templates/home.php';
?>