<?php
require_once '../includes/config.php';
require_once '../includes/db.php';
require_once '../includes/functions.php';

// Redirect if not logged in
if (!isLoggedIn()) {
    setFlashMessage('danger', 'Please log in to access the dashboard');
    redirect(APP_URL . '/pages/login.php');
}

$pageTitle = 'Dashboard';
$userId = $_SESSION['user_id'];

// Get user data
$user = getUserById($userId);

// Get user's books
$books = $db->select("SELECT * FROM books WHERE user_id = ? ORDER BY created_at DESC", [$userId]);

include '../templates/header.php';
?>

<div class="row mb-4">
    <div class="col">
        <h1>Welcome, <?php echo sanitize($user['username']); ?>!</h1>
        <p>Manage your books and links here.</p>
    </div>
    <div class="col-auto">
        <a href="<?php echo APP_URL; ?>/pages/edit-book.php" class="btn btn-primary">Add New Book</a>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-header">
                <h4>Your Profile</h4>
            </div>
            <div class="card-body">
                <p><strong>Username:</strong> <?php echo sanitize($user['username']); ?></p>
                <p><strong>Email:</strong> <?php echo sanitize($user['email']); ?></p>
                <p><strong>Your Link:</strong> <a href="<?php echo APP_URL . '/' . sanitize($user['permalink']); ?>" target="_blank"><?php echo APP_URL . '/' . sanitize($user['permalink']); ?></a></p>
                <a href="<?php echo APP_URL; ?>/pages/edit-profile.php" class="btn btn-secondary">Edit Profile</a>
            </div>
        </div>
    </div>

    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4>Your Books</h4>
            </div>
            <div class="card-body">
                <?php if (empty($books)): ?>
                    <div class="alert alert-info">
                        You haven't added any books yet. <a href="<?php echo APP_URL; ?>/pages/edit-book.php">Add your first book</a>.
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Status</th>
                                    <th>Created</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($books as $book): ?>
                                    <tr>
                                        <td><?php echo sanitize($book['title']); ?></td>
                                        <td>
                                            <?php if ($book['is_published']): ?>
                                                <span class="badge bg-success">Published</span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">Draft</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo date('M j, Y', strtotime($book['created_at'])); ?></td>
                                        <td>
                                            <a href="<?php echo APP_URL; ?>/pages/edit-book.php?id=<?php echo $book['id']; ?>" class="btn btn-sm btn-primary">Edit</a>
                                            <a href="<?php echo APP_URL; ?>/pages/edit-buttons.php?book_id=<?php echo $book['id']; ?>" class="btn btn-sm btn-secondary">Links</a>
                                            <a href="<?php echo APP_URL . '/' . sanitize($user['permalink']); ?>" target="_blank" class="btn btn-sm btn-success">View</a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include '../templates/footer.php'; ?>